EvaluateSystemScript("clock.js");
EvaluateSystemScript("timed_animation.js");

// This is the main game file. All of the player's data is stored here.
function GameData()
{
	var t = new Object();
	t.money = 0;		// Current amount of money held by the party
	t.clock = new Clock()	// Game clock
	t.time = "";
	t.party = new Array();	// Characters that have joined
	t.spells = new Array(); // Spells party is currently carrying
	t.techniques = new Array(); // Techniques party is currently carrying
	t.psize = 1;		// Current size of party
	t.events = new Array();	// Events that have happened in the game
	t.menuopen = false;	// Is there a menu open
	t.currentmenu;		// Menu that is open
	t.currentbattle;	// Battle that is open
	t.messageopen = false;	// Is there a message open
	t.submenu = new Menu(true);
	t.submenu.addItem("Fusion");
	t.submenu.addItem("Inventory");
	t.submenu.addItem("Abilities");
	t.submenu.addItem("Equipment");
	t.submenu.addItem("Status", StatusMenu);
	t.submenu.addItem("Krylic");
	t.submenu.addItem("Order");
	t.submenu.addItem("Customize");
	t.submenu.addItem("Save/Load");
	t.submenu.addItem("Exit");
	t.messagex = 0;		// Open message's x value
	t.messagey = 0;		// Open message's y value
	t.messagew = 0;		// Open message's w value
	t.messagespeaker = "";	// Open message's speaker
	t.messagetext = "";	// Open message's text
	t.messageletter = 0;	// Open message's current letter
	t.messagetime = 0;	// Time until message disappears
	t.items = new Array();	// Items held by the party
	t.accept = KEY_A;	// Accept key
	t.cancel = KEY_SPACE;	// Cancel key
	t.menu = KEY_F;		// Menu key
	t.saveable = false;	// Is it possible to save
	t.freeze = false;	// Are the controls frozen
	t.area = false;		// Is there a submap warp here
	t.areax = 0;		// x coordinate of ShowArea()
	t.areay = 0;		// y coordinate of ShowArea()
	t.areatext = "";	// Name of current area
	t.areamap = "";		// Name of current map
	t.world = "Gaias";	// Current world
	t.menu_move = LoadSound("Cursor-move.wav");
	t.menu_accept = LoadSound("Cursor-accept.wav");
	t.menu_cancel = LoadSound("Cursor-cancel.wav");
	return t;
}


// This warps the player to another map. It will automatically switch to a
// larger sprite if they are warped to one that requires it
function Warp(amap)
{
	FadeOut(200);
	if (amap.substr(0, 6) == "World/")
	{
		DetachInput();
		DetachCamera();
		for (var i = 0; i < Game.psize; i ++)
		{
			DestroyPerson(Game.party[i].name);
		}
		for (var i = 0; i < Game.psize; i ++)
		{
			CreatePerson(Game.party[i].name, Game.party[i].name + "-big.rss", false);
		}
		AttachCamera(Game.party[0].name);
		AttachInput(Game.party[0].name);
	}
	ChangeMap(amap);
	RenderMap();
	FadeIn(200);
}

// This does all the spiffy intro stuff
function Introduction(fade_speed)
{
	this.events = new Array();
	this.bg = Colors.Black;
	this.current_event = 0;
	this.current_process = "FadeFrom";
	this.pressed = false;
	this.timer = 0;
	this.step = 255;
	this.fade_speed = fade_speed;
	this.music = false;
}

// Add a new event to the intro scene
Introduction.prototype.addEvent = function(type, file, wait)
{
	var event = new Object();
	event.type = type;
	if (type == "Image")
	{
		event.file = LoadImage(file);
	}
	if (type == "Text")
	{
		event.file = file;
	}
	if (type == "Animation")
	{
		event.file = new TimedAnimation(LoadAnimation(file));
	}
	event.wait = wait;
	this.events[this.events.length] = event;
}

// Play the intro scene
Introduction.prototype.play = function()
{
	var playing = true;
	if (this.music != false)
	{
		this.music.play(true);
	}
	while (playing)
	{
		ApplyColorMask(this.bg);
		if (this.events[this.current_event] != undefined)
		{
			if (this.events[this.current_event].type == "Image")
			{
				this.events[this.current_event].file.blit(GetScreenWidth() / 2 - (this.events[this.current_event].file.width / 2), GetScreenHeight() / 2 - (this.events[this.current_event].file.height / 2));
			}
			if (this.events[this.current_event].type == "Text")
			{
				font.title.drawText(GetScreenWidth() / 2 - (font.title.getStringWidth(this.events[this.current_event].file) / 2), GetScreenHeight() / 2 - 9, this.events[this.current_event].file);
			}
			if (this.events[this.current_event].type == "Animation")
			{
				this.events[this.current_event].file.blit(GetScreenWidth() / 2 - (this.events[this.current_event].file.animation.getWidth() / 2), GetScreenHeight() / 2 - (this.events[this.current_event].file.animation.getHeight() / 2));
			}
		}
		// Fade from
		if (this.current_process == "FadeFrom")
		{
			Fade(this.step, Colors.Black);
			this.step -= this.fade_speed;
			if (this.step < 0)
			{
				this.current_process = "Wait";
				this.timer = GetTime();
			}
		}
		if (this.current_process == "Wait")
		{
			if (this.timer + this.events[this.current_event].wait <= GetTime())
			{
				this.current_process = "FadeTo";
			}
		}
		// Fade to
		if (this.current_process == "FadeTo")
		{
			Fade(this.step, Colors.Black);
			this.step += this.fade_speed;
			if (this.step > 255)
			{
				if (this.pressed == false)
				{
					this.current_event ++;
					this.current_process = "FadeFrom";
				}
				if (this.pressed == true)
				{
					playing = false;
				}
			}
		}
		FlipScreen();
		if (this.events[this.current_event] == undefined)
		{
			playing = false;
		}
		if (IsKeyPressed(KEY_ENTER))
		{
			this.current_process = "FadeTo";
			this.pressed = true;
		}
	}
	if (this.music != false)
	{
		this.music.stop();
	}
}

function Fade(step, color)
{
	ApplyColorMask(CreateColor(color.red, color.green, color.blue, step));
}

// This will return the correct radians from degrees
function DtR(degree)
{
	if (degree >= 0)
		return Math.PI * degree / 180;
	if (degree < 0)
		return Math.PI * (360 + degree) / 180;
}

function GetPartySize()
{
	var psize = Game.party.length;
	if (Game.party.length > 3)
	{
		psize = 3;
	}
	return psize;
}